#include "camera_setting.h"
#include "color_detection.hpp"
#include "iic_data_send.hpp"

static QueueHandle_t xQueueAIFrame = NULL;
static QueueHandle_t xQueueIICData = NULL;

void setup() {
  /* Create an image transfer queue */
  xQueueAIFrame = xQueueCreate(2, sizeof(camera_fb_t *)); 
  /* Create an IIC data transmission queue */
  xQueueIICData = xQueueCreate(2, sizeof(color_data_t *) * SEND_CLOLOR_NUM);

  /* Register camera processing tasks */
  register_camera(PIXFORMAT_RGB565, FRAMESIZE_240X240, 4, xQueueAIFrame);
  /* Registering the color recognition task */
  register_color_detection(xQueueAIFrame, NULL, xQueueIICData, NULL, true);
  /* Register IIC data transmission task */
  register_iic_data_send(xQueueIICData, NULL);

}

void loop() 
{
}
