#include "camera_setting.h"
#include "color_detection.hpp"
#include "iic_data_send.hpp"

static QueueHandle_t xQueueAIFrame = NULL;
static QueueHandle_t xQueueIICData = NULL;

void setup() {
  /* Create an image transfer queue */
  xQueueAIFrame = xQueueCreate(2, sizeof(camera_fb_t *)); 
  /* Create an IIC data transmission queue */
  xQueueIICData = xQueueCreate(2, sizeof(send_color_data_t));

  /* Register camera processing tasks */
  register_camera(PIXFORMAT_RGB565, FRAMESIZE_QQVGA, 4, xQueueAIFrame);
  /* Registering a line-hunting detection task */
  register_color_detection(xQueueAIFrame, NULL, xQueueIICData, NULL, true);
  /* Register IIC data transmission task */
  register_iic_data_send(xQueueIICData, NULL);

}

void loop() 
{
}
