#include "iic_data_send.hpp"
#include "Wire.h"

#define I2C_SLAVE_ADDRESS 0x43

static QueueHandle_t xQueueResultI = NULL;
static QueueHandle_t xQueueResultO = NULL;

static const char *TAG = "iic_data_send";
static const int sdaPin = 47;
static const int sclPin = 48;
static const uint32_t i2cFrequency = 100000;

send_color_data_t send_color_data[5];

static uint8_t rec = 0xFF;
static uint8_t send_data[5] = {0};

static void iic_receive(int len)
{
  while(Wire.available())
  {
    rec = Wire.read();
  }  
}

static void iic_request()
{
    /* Send red color block data */
    if(rec == 0x00) 
    {
        send_data[0] = send_color_data[0].center_x;
        send_data[1] = send_color_data[0].center_y;
        send_data[2] = send_color_data[0].width;
        send_data[3] = send_color_data[0].length;

    }
    /* Send green color block data */
    else if(rec == 0x01)
    {
        send_data[0] = send_color_data[1].center_x;
        send_data[1] = send_color_data[1].center_y;
        send_data[2] = send_color_data[1].width;
        send_data[3] = send_color_data[1].length;

    }
    /* Send blue color block data */
    else if(rec == 0x02)
    {
        send_data[0] = send_color_data[2].center_x;
        send_data[1] = send_color_data[2].center_y;
        send_data[2] = send_color_data[2].width;
        send_data[3] = send_color_data[2].length;

    }
    /* Send purple block data */
    else if(rec == 0x03)
    {
        send_data[0] = send_color_data[3].center_x;
        send_data[1] = send_color_data[3].center_y;
        send_data[2] = send_color_data[3].width;
        send_data[3] = send_color_data[3].length;
      
    }
    /* Send black block data */
    else if(rec == 0x04)
    {
        send_data[0] = send_color_data[0].id;
        send_data[1] = send_color_data[1].id;
        send_data[2] = send_color_data[2].id;
        send_data[3] = send_color_data[3].id;      
    }
    /* Pack and send color block data */
    Wire.slaveWrite(send_data, sizeof(send_data));
}

static void task_process_handler(void *arg)
{
  /* IIC initialization */
  Wire.begin((uint8_t)I2C_SLAVE_ADDRESS, sdaPin, sclPin, i2cFrequency);
  /* Register a callback function to receive data */
  Wire.onReceive(iic_receive);
  /* Register a callback function for requesting data */
  Wire.onRequest(iic_request);

  while (true)
  {

    if (xQueueReceive(xQueueResultI, &send_color_data, portMAX_DELAY))
    {

        // printf("center_x: red:%d  yellow:%d  green:%d  blue:%d\r\n", send_color_data[0].center_x, \
        //                                                              send_color_data[1].center_x, \
        //                                                              send_color_data[2].center_x, \
        //                                                              send_color_data[3].center_x);
    }
  }
}

void register_iic_data_send(const QueueHandle_t result_i,
                            const QueueHandle_t result_o)
{
  xQueueResultI = result_i;
  xQueueResultO = result_o;

  xTaskCreatePinnedToCore(task_process_handler, TAG, 5 * 1024, NULL, 5, NULL, 1);
}