//Board: esp32_2.0.11
//Go to Tools > Board and select ESP32S3 Dev Module.
//Flash Size: 8MB
//Partition Scheme: Huge APP
//PSRAM: OPI PSRAM

#include "esp_camera.h"
#include <WiFi.h>
//
// WARNING!!! PSRAM IC required for UXGA resolution and high JPEG quality
//            Ensure ESP32 Wrover Module or other board with PSRAM is selected
//            Partial images will be transmitted if image exceeds buffer size
//
//            You must select partition scheme from the board menu that has at least 3MB APP space.
//            Face Recognition is DISABLED for ESP32 and ESP32-S2, because it takes up from 15 
//            seconds to process single frame. Face Detection is ENABLED if PSRAM is enabled as well

// ===================
// Select camera model
// ===================
//#define CAMERA_MODEL_WROVER_KIT // Has PSRAM
//#define CAMERA_MODEL_ESP_EYE // Has PSRAM
#define CAMERA_MODEL_ESP32S3_EYE // Has PSRAM
//#define CAMERA_MODEL_M5STACK_PSRAM // Has PSRAM
//#define CAMERA_MODEL_M5STACK_V2_PSRAM // M5Camera version B Has PSRAM
//#define CAMERA_MODEL_M5STACK_WIDE // Has PSRAM
//#define CAMERA_MODEL_M5STACK_ESP32CAM // No PSRAM
//#define CAMERA_MODEL_M5STACK_UNITCAM // No PSRAM
//#define CAMERA_MODEL_AI_THINKER // Has PSRAM
//#define CAMERA_MODEL_TTGO_T_JOURNAL // No PSRAM
//#define CAMERA_MODEL_XIAO_ESP32S3 // Has PSRAM
// ** Espressif Internal Boards **
//#define CAMERA_MODEL_ESP32_CAM_BOARD
//#define CAMERA_MODEL_ESP32S2_CAM_BOARD
//#define CAMERA_MODEL_ESP32S3_CAM_LCD
//#define CAMERA_MODEL_DFRobot_FireBeetle2_ESP32S3 // Has PSRAM
//#define CAMERA_MODEL_DFRobot_Romeo_ESP32S3 // Has PSRAM
#include "camera_pins.h"

#define AP_MODE   0 // Set AP_MODE 1 (for AP mode or hotspot mode). Set AP_MODE 0 (for WiFi mode)

// ===========================
// Enter your WiFi credentials
// ===========================
#if AP_MODE
const char* ssid = "AiRO_ESP32S3CAM505";
const char* password = "";
IPAddress local_ip(192, 168, 5, 1);       // Setting a custom IP address
IPAddress gateway(192, 168, 1, 1);        // Gateway address
IPAddress subnet(255, 255, 255, 0);       // Subnet mask
#else
const char* ssid = "bluecart"; //"this_is_my_local_wifi_ssid"; // Change this to be your local SSID
const char* password = "yellowcard"; //"this_is_my_password"; // Change this to be your password
#endif

void startCameraServer();

void setup() {
  Serial.begin(115200);
  Serial.println();

  camera_config_t config;
  config.ledc_channel = LEDC_CHANNEL_0;
  config.ledc_timer = LEDC_TIMER_0;
  config.pin_d0 = Y2_GPIO_NUM;
  config.pin_d1 = Y3_GPIO_NUM;
  config.pin_d2 = Y4_GPIO_NUM;
  config.pin_d3 = Y5_GPIO_NUM;
  config.pin_d4 = Y6_GPIO_NUM;
  config.pin_d5 = Y7_GPIO_NUM;
  config.pin_d6 = Y8_GPIO_NUM;
  config.pin_d7 = Y9_GPIO_NUM;
  config.pin_xclk = XCLK_GPIO_NUM;
  config.pin_pclk = PCLK_GPIO_NUM;
  config.pin_vsync = VSYNC_GPIO_NUM;
  config.pin_href = HREF_GPIO_NUM;
  config.pin_sccb_sda = SIOD_GPIO_NUM;
  config.pin_sccb_scl = SIOC_GPIO_NUM;
  config.pin_pwdn = PWDN_GPIO_NUM;
  config.pin_reset = RESET_GPIO_NUM;
  config.xclk_freq_hz = 15000000;
  /* @param frame_size   One of
   *                     - FRAMESIZE_96X96,    // 96x96
   *                     - FRAMESIZE_QQVGA,    // 160x120
   *                     - FRAMESIZE_QCIF,     // 176x144
   *                     - FRAMESIZE_HQVGA,    // 240x176
   *                     - FRAMESIZE_240X240,  // 240x240
   *                     - FRAMESIZE_QVGA,     // 320x240
   *                     - FRAMESIZE_CIF,      // 400x296
   *                     - FRAMESIZE_HVGA,     // 480x320
   *                     - FRAMESIZE_VGA,      // 640x480
   *                     - FRAMESIZE_SVGA,     // 800x600
   *                     - FRAMESIZE_XGA,      // 1024x768
   *                     - FRAMESIZE_HD,       // 1280x720
   *                     - FRAMESIZE_SXGA,     // 1280x1024
   *                     - FRAMESIZE_UXGA,     // 1600x1200
   *                     - FRAMESIZE_FHD,      // 1920x1080
   *                     - FRAMESIZE_P_HD,     //  720x1280
   *                     - FRAMESIZE_P_3MP,    //  864x1536
   *                     - FRAMESIZE_QXGA,     // 2048x1536
   *                     - FRAMESIZE_QHD,      // 2560x1440
   *                     - FRAMESIZE_WQXGA,    // 2560x1600
   *                     - FRAMESIZE_P_FHD,    // 1080x1920
   *                     - FRAMESIZE_QSXGA,    // 2560x1920
   */
  config.frame_size = FRAMESIZE_QVGA;
  config.pixel_format = PIXFORMAT_RGB565; // for streaming
  //config.pixel_format = PIXFORMAT_RGB565; // for face detection/recognition
  config.grab_mode = CAMERA_GRAB_WHEN_EMPTY;
  config.fb_location = CAMERA_FB_IN_PSRAM;
  config.jpeg_quality = 12;
  config.fb_count = 1;
  
  // if PSRAM IC present, init with UXGA resolution and higher JPEG quality
  //                      for larger pre-allocated frame buffer.
  if(config.pixel_format == PIXFORMAT_JPEG){
    if(psramFound()){
      config.jpeg_quality = 10;
      config.fb_count = 2;
      config.grab_mode = CAMERA_GRAB_LATEST;
    } else {
      // Limit the frame size when PSRAM is not available
      config.frame_size = FRAMESIZE_SVGA;
      config.fb_location = CAMERA_FB_IN_DRAM;
    }
  } else {
    // Best option for face detection/recognition
    config.frame_size = FRAMESIZE_240X240;
#if CONFIG_IDF_TARGET_ESP32S3
    config.fb_count = 2;
#endif
  }

#if defined(CAMERA_MODEL_ESP_EYE)
  pinMode(13, INPUT_PULLUP);
  pinMode(14, INPUT_PULLUP); 
#endif

  // camera init
  esp_err_t err = esp_camera_init(&config);
  if (err != ESP_OK) {
    Serial.printf("Camera init failed with error 0x%x", err);
    return;
  }

  sensor_t * s = esp_camera_sensor_get();
#if defined(CAMERA_MODEL_ESP32S3_EYE)
  // s->set_vflip(s, 1);
#endif
#if AP_MODE
  WiFi.mode(WIFI_AP);
  WiFi.softAP(ssid, password, 6, false, 4); // SSID, password, channel 6, do not hide SSID, maximum number of connections 4
  // WiFi.begin(ssid, password);
  WiFi.setSleep(false);
  // Configuring IP addresses
  if (!WiFi.softAPConfig(local_ip, gateway, subnet)) {
    Serial.println("Failed to configure IP");
  }
  Serial.println("WiFi AP Started");
  Serial.print("AP IP Address: ");
  Serial.println(WiFi.softAPIP()); // Output the AP’s IP address
  startCameraServer();
  pinMode(2, OUTPUT);
  digitalWrite(2, LOW);
#else
  WiFi.begin(ssid, password);
  WiFi.setSleep(false);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected");

  startCameraServer();

  Serial.print("Camera Ready! Use 'http://");
  Serial.print(WiFi.localIP());
  Serial.println("' to connect");
#endif
}

void loop() {
  // Do nothing. Everything is done in another task by the web server
  delay(10000);
}
