//Board: esp32_2.0.17
//Go to Tools > Board and select ESP32S3 DEV MODULE
//Flash Size: 8MB(64Mb)
//PSRAM: OPI PSRAM
//Partition Scheme: Huge APP (3MB No OTA/1MB SPIFFS)

/*
  ESP32S3WroomSingleBoard_CollectImages.ino - Code for Reka Edukit Eksplorasi AI
  Created by Amir Hussein Jaafar, 31st July, 2025.
  Copyright (c) 2025.  All right reserved. 
*/
/*
  Modified by Amir Hussein Jaafar, 2nd Oct, 2025.

*/

/**
 * Collect images for Edge Impulse image
 * classification / object detection
 *
 * BE SURE TO SET "TOOLS > CORE DEBUG LEVEL = INFO"
 * to turn on debug messages
 */

// if you define WIFI_SSID and WIFI_PASS before importing the library, 
// you can call connect() instead of connect(ssid, pass)
//
// If you set HOSTNAME and your router supports mDNS, you can access
// the camera at http://{HOSTNAME}.local

#define WIFI_SSID "Edu4WRD_Robotics" // Replace with your WiFi SSID
#define WIFI_PASS "yellowcard" // Replace with your WiFi password
#define HOSTNAME "esp32cam"

#include <eloquent_esp32cam.h>
#include <eloquent_esp32cam/extra/esp32/wifi/sta.h>
#include <eloquent_esp32cam/viz/image_collection.h>

using eloq::camera;
using eloq::wifi;
using eloq::viz::collectionServer;


void setup() {
    delay(3000);
    Serial.begin(115200);
    Serial.println("___IMAGE COLLECTION SERVER___");

    // camera settings
    // replace with your own model!
    camera.pinout.wroom_s3();
    //camera.pinout.aithinker();
    camera.brownout.disable();
    // Edge Impulse models work on square images
    // face resolution is 240x240
    camera.resolution.face();
    camera.quality.high();

    // init camera
    while (!camera.begin().isOk())
        Serial.println(camera.exception.toString());
    Serial.println("Camera OK");

    // flipped camera for OV3660
    bool flipped = false;
    sensor_t *s = camera.sensor.sensor; 
    if(s->id.PID == OV3660_PID){
        flipped = camera.sensor.vflip();
        camera.sensor.highBrightness();
        camera.sensor.lowSaturation();
    }
    Serial.print("Camera vertical: ");
    if(flipped)
        Serial.println("Flipped");
    else
        Serial.println("Not flipped");

    // connect to WiFi
    while (!wifi.connect().isOk())
      Serial.println(wifi.exception.toString());
    Serial.println("WiFi OK");

    // init face detection http server
    while (!collectionServer.begin().isOk())
        Serial.println(collectionServer.exception.toString());
    Serial.println("Image Collection Server OK");
    Serial.println(collectionServer.address());
}


void loop() {
    // server runs in a separate thread, no need to do anything here
}